#region Using directives
using System;
using System.IO;
using System.Threading;
using System.Windows;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.UI;
using FTOptix.NativeUI;
using FTOptix.HMIProject;
using FTOptix.Report;
using FTOptix.Retentivity;
using FTOptix.CoreBase;
using FTOptix.Core;
using FTOptix.NetLogic;
using FTOptix.CODESYS;
using FTOptix.CommunicationDriver;
using FTOptix.RAEtherNetIP;
using FTOptix.SerialPort;
using FTOptix.System;
using FTOptix.Store;
using FTOptix.DataLogger;
using FTOptix.SQLiteStore;
#endregion

public class RuntimeChartHTML : BaseNetLogic
{

    public override void Start()
    {
        myPeriodicTask = new PeriodicTask(RefresheChartGraph, 5000, LogicObject);
        myPeriodicTask.Start();

    }

    public override void Stop()
    {
        myPeriodicTask.Dispose();
    }


    [ExportMethod]
    public void RefresheChartGraph()
    {
        //		UpdateChartGraph("Template-pie-roseType-simple", "pie-roseType-simple", 1, 8, "Model/Dashboard/OEE/eChart", "wbOEE");

        UpdateChartGraph("templateName", "fileName", "modelPath", "wbName");

    }

    public void UpdateChartGraph(string templateName, string fileName, string modelPath, string wbName)
    {
        Log.Debug("eCharts", "Starting");
        string optixPath = "C:\\Rockwell Automation\\FT Optix\\EnergyMonitoring\\ProjectFiles\\Sankey\\Optix.html";

        string templatePath = "C:\\Rockwell Automation\\FT Optix\\EnergyMonitoring\\ProjectFiles\\Sankey\\Template-Sankey.html";
        string filePath = "C:\\Rockwell Automation\\FT Optix\\EnergyMonitoring\\ProjectFiles\\Sankey\\Sankey.html";

        string text = File.ReadAllText(templatePath);

        Project.Current.GetVariable("Model/Variables/Electric/main").Value = (Project.Current.GetVariable("Model/Variables/Electric/meter1/kw").Value * 1) + (Project.Current.GetVariable("Model/Variables/Electric/meter2/kw").Value * 1);

        text = text.Replace("$01", (Project.Current.GetVariable("Model/Variables/Electric/meter1/kw").Value * 1).ToString());
        text = text.Replace("$02", (Project.Current.GetVariable("Model/Variables/Electric/meter2/kw").Value * 1).ToString());
        text = text.Replace("$03", (Project.Current.GetVariable("Model/Variables/Electric/meter3/kw").Value * 1).ToString());
        text = text.Replace("$04", (Project.Current.GetVariable("Model/Variables/Electric/meter4/kw").Value * 1).ToString());
        text = text.Replace("$05", (Project.Current.GetVariable("Model/Variables/Electric/meter5/kw").Value * 1).ToString());
        text = text.Replace("$06", (Project.Current.GetVariable("Model/Variables/Electric/meter6/kw").Value * 1).ToString());
        text = text.Replace("$07", (Project.Current.GetVariable("Model/Variables/Electric/meter7/kw").Value * 1).ToString());
        text = text.Replace("$08", (Project.Current.GetVariable("Model/Variables/Electric/meter8/kw").Value * 1).ToString());
        text = text.Replace("$09", (Project.Current.GetVariable("Model/Variables/Electric/meter9/kw").Value * 1).ToString());
        text = text.Replace("$10", (Project.Current.GetVariable("Model/Variables/Electric/meter10/kw").Value * 1).ToString());
        text = text.Replace("$11", (Project.Current.GetVariable("Model/Variables/Electric/meter11/kw").Value * 1).ToString());
        text = text.Replace("$12", (Project.Current.GetVariable("Model/Variables/Electric/meter12/kw").Value * 1).ToString());
        text = text.Replace("$13", (Project.Current.GetVariable("Model/Variables/Electric/meter13/kw").Value * 1).ToString());
        text = text.Replace("$14", (Project.Current.GetVariable("Model/Variables/Electric/meter14/kw").Value * 1).ToString());
        text = text.Replace("$15", (Project.Current.GetVariable("Model/Variables/Electric/meter15/kw").Value * 1).ToString());
        text = text.Replace("$16", (Project.Current.GetVariable("Model/Variables/Electric/meter16/kw").Value * 1).ToString());
        text = text.Replace("$17", (Project.Current.GetVariable("Model/Variables/Electric/meter17/kw").Value * 1).ToString());


        File.WriteAllText(filePath, text);

        Log.Debug("eCharts", "Finished");
        Thread.Sleep(1);

    }

    private PeriodicTask myPeriodicTask;

}
