using System;
using FTOptix.Core;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using System.Linq;
using CoreBase = FTOptix.CoreBase;
using FTOptix.UI;
using FTOptix.HMIProject;
using FTOptix.CoreBase;

public class UIPopulator : FTOptix.NetLogic.BaseNetLogic
{
    public override void Start()
    {
		// Insert code to be executed when the user-defined logic is started
		var owner = (ColumnLayout) LogicObject.Owner;

		modelObjectVariable = LogicObject.Get<IUAVariable>("ModelObject");
		modelObjectVariable.VariableChange += ModelObjectVariable_VariableChange;

		BuildUI(modelObjectVariable.Value);
	}

	private void ModelObjectVariable_VariableChange(object sender, VariableChangeEventArgs e)
	{
		BuildUI(e.NewValue);
	}

	public override void Stop()
    {
		// Insert code to be executed when the user-defined logic is stopped
		modelObjectVariable.VariableChange -= ModelObjectVariable_VariableChange;
	}

	private void BuildUI(NodeId modelObjectNodeId)
	{
		var owner = (ColumnLayout)LogicObject.Owner;

		var modelObject = LogicObject.Context.GetObject(modelObjectNodeId);

        foreach (var child in Owner.Children.OfType<Item>())
        {
            child.Delete();
        }

		foreach (var variable in modelObject.Children.OfType<IUAVariable>())
		{
			Item uiObject = null;

			if (variable.DataType == OpcUa.DataTypes.Boolean)
			{
				uiObject = MakeSwitch(variable);
			}
			else if (variable.DataType == OpcUa.DataTypes.String)
			{
				uiObject = MakeTextBox(variable);
			}
			else if (variable.DataType == OpcUa.DataTypes.Int32)
			{
				uiObject = MakeLinearGauge(variable);
			}
			else if (variable.DataType == OpcUa.DataTypes.Float)
			{
				uiObject = MakeCircularGauge(variable);
			}
			else if (variable.DataType == FTOptix.Core.DataTypes.ResourceUri)
			{
				uiObject = MakeImage(variable);
			}

			if (uiObject != null)
				owner.Children.Add(uiObject);
		}
	}

	private Panel MakeBaseContainer(IUAVariable variable)
	{
		var container = InformationModel.MakeObject<Panel>("ControlContainer");
		container.Height = 50;
		container.HorizontalAlignment = HorizontalAlignment.Stretch;

		var label = InformationModel.MakeObject<Label>("Label");
		label.VerticalAlignment = VerticalAlignment.Center;
		label.LeftMargin = 20;
		label.Text = variable.BrowseName;
		container.Children.Add(label);
		return container;
	}

	private Item MakeSwitch(IUAVariable variable)
	{
		var container = MakeBaseContainer(variable);
		var mySwitch = InformationModel.MakeObject<Switch>("Switch");
		mySwitch.HorizontalAlignment = HorizontalAlignment.Right;
		mySwitch.VerticalAlignment = VerticalAlignment.Center;
		mySwitch.RightMargin = 40;

		MakeDataBind(mySwitch.Children.Get<IUAVariable>("Checked"), variable);

		container.Children.Add(mySwitch);
		return container;
	}

	private Item MakeTextBox(IUAVariable variable)
	{
		var container = MakeBaseContainer(variable);
		var textBox = InformationModel.MakeObject<TextBox>("TextBox");
		textBox.HorizontalAlignment = HorizontalAlignment.Right;
		textBox.VerticalAlignment = VerticalAlignment.Center;
		textBox.RightMargin = 40;

		MakeDataBind(textBox.Children.Get<IUAVariable>("Text"), variable);

		container.Children.Add(textBox);
		return container;
	}

	private Item MakeCircularGauge(IUAVariable variable)
	{
		var container = MakeBaseContainer(variable);
		container.Height = 180;
		var circularGauge = InformationModel.MakeObject<CircularGauge>("CircularGauge");
		circularGauge.Width = 140;
		circularGauge.HorizontalAlignment = HorizontalAlignment.Right;
		circularGauge.VerticalAlignment = VerticalAlignment.Stretch;
		circularGauge.RightMargin = 40;
		circularGauge.TopMargin = 20;

		MakeDataBind(circularGauge.Children.Get<IUAVariable>("Value"), variable);

		container.Children.Add(circularGauge);
		return container;
	}

	private Item MakeLinearGauge(IUAVariable variable)
	{
		var container = MakeBaseContainer(variable);
		container.Height = 150;
		var linearGauge = InformationModel.MakeObject<LinearGauge>("LinearGauge");
		linearGauge.Width = 140;
		linearGauge.Height = 35;
		linearGauge.HorizontalAlignment = HorizontalAlignment.Right;
		linearGauge.VerticalAlignment = VerticalAlignment.Center;
		linearGauge.RightMargin = 40;
		linearGauge.TopMargin = 20;

		MakeDataBind(linearGauge.Children.Get<IUAVariable>("Value"), variable);

		container.Children.Add(linearGauge);
		return container;
	}

	private Item MakeImage(IUAVariable variable)
	{
		var image = InformationModel.MakeObject<Image>("Image");

		image.HorizontalAlignment = HorizontalAlignment.Center;
		image.Width = 100;
		image.Height = 100;
		image.TopMargin = 20;
		image.BottomMargin = 20;
		image.Path = new FTOptix.Core.ResourceUri(variable.Value);

		return image;
	}

	private void MakeDataBind(IUAVariable parent, IUAVariable variable)
	{
		/* 
		var dataBind = InformationModel.MakeVariable<DataBind>("DataBind", FTOptix.Core.DataTypes.NodePath);
		dataBind.Value = DataBindPath.MakeAbsolutePath(variable);
		dataBind.Mode = DynamicLinkMode.ReadWrite;
		parent.SetDynamicLink(dataBind);
		*/
		parent.SetDynamicLink(variable, FTOptix.CoreBase.DynamicLinkMode.ReadWrite);
	}

	private IUAVariable modelObjectVariable;
}
