#region Using directives
using FTOptix.NetLogic;
using FTOptix.UI;
using System.Xml.Linq;
using System.Linq;
using UAManagedCore;
using System.Threading;
#endregion

public class RuntimeNetLogic1 : BaseNetLogic
{
    public override void Start()
    {
        // LogicObject.Owner is the button, so LogicObject.Owner is the MainWindow
        svgImage = LogicObject.Owner.Children.Get<AdvancedSVGImage>("AdvancedSVGImage1");

        // Retrieve the Path to the SVG
        var imageAbsolutePath = svgImage.Path.Uri;

        // Load the SVG into an XDocument
        xDocument = XDocument.Load(imageAbsolutePath);

        // Find the first path element
        var pathNode = xDocument.Descendants().Where(x => x.Name.LocalName == "path").FirstOrDefault();

        // Find the first polygon element
        var polyNode = xDocument.Descendants().Where(x => x.Name.LocalName == "polygon").FirstOrDefault();

        // Get the polygon transform attribute
        polyTransformAttribute = polyNode.Attribute("transform");

        // Get the polygon transform attribute
        pathTransformAttribute = pathNode.Attribute("transform");
    }

    public override void Stop()
    {
        keepGoing = false;

        if (myLRT != null)
            myLRT.Dispose();
    }

    private void doRotate()
    {
        int degrees = 3;

        while (keepGoing)
        {
            Thread.Sleep(50);

            degrees += 3;
            if (degrees > 360)
                degrees = 0;
            string newTransformPoly = new string("rotate(" + degrees + ", 50, 250)");
            polyTransformAttribute.SetValue(newTransformPoly);

            string newTransformPath = new string("rotate(" + degrees + ", 96, 97)");
            pathTransformAttribute.SetValue(newTransformPath);

            //Update the SVG
            svgImage.SetImageContent(xDocument.ToString());
        }
    }

    [ExportMethod]
    public void rotateSVG()
    {
        keepGoing = false;
        if (myLRT != null)
            myLRT.Dispose();

        keepGoing = true;
        myLRT = new LongRunningTask(doRotate, LogicObject);
        myLRT.Start();
    }

    private XDocument xDocument;
    private AdvancedSVGImage svgImage;
    private XAttribute polyTransformAttribute;
    private XAttribute pathTransformAttribute;
    private LongRunningTask myLRT;
    private bool keepGoing = true;
}