#region Using directives
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.HMIProject;
using FTOptix.Core;
using FTOptix.Alarm;
using FTOptix.NetLogic;
#endregion

public class AlarmImporter : BaseNetLogic
{
    [ExportMethod]
    public void ImportAlarms()
    {
        // Reads the CSVPath property of the NetLogic. It is configured with datatype Absolute resource URI
        string csvPathVariable = LogicObject.GetVariable("CSVPath").Value;

        var csvPath = new ResourceUri(csvPathVariable).Uri;

        var modelFolder = Project.Current.Get("Model");
        var alarmsFolder = Project.Current.Get("Alarms");

        if (csvPath.Length == 0 || !System.IO.File.Exists(csvPath))
        {
            Log.Error("CSV not found. Please configure the CSV to parse in the NetLogic configuration");
            return;
        }

        // Clear the content of Model and Alarms folders, just for the sake of the example. It let you re-run the command
        // without adding the same alarm or variable again.
        modelFolder.Children.Clear();
        alarmsFolder.Children.Clear();

        string[] lines = System.IO.File.ReadAllLines(csvPath);

        foreach (string line in lines)
        {
            var tokens = line.Split(',');

            if (tokens[0] == "variable")
            {
                NodeId dataType = tokens[2] == "boolean" ? OpcUa.DataTypes.Boolean : OpcUa.DataTypes.UInt32;

                var newVariable = InformationModel.MakeVariable(tokens[1], dataType);
                modelFolder.Add(newVariable);
            }
            else if (tokens[0] == "alarm")
            {
                // Searches the variable to link before creating the alarm
                var inputVariable = modelFolder.GetVariable(tokens[3]);

                AlarmController newAlarm;

                if (tokens[2] == "digital")
                    newAlarm = InformationModel.MakeObject<DigitalAlarm>(tokens[1]);
                else
                    newAlarm = InformationModel.MakeObject<ExclusiveLevelAlarmController>(tokens[1]);

                // Creates a dynamic link from the InputValue property of the Alarm to the actual variable
                newAlarm.InputValueVariable.SetDynamicLink(inputVariable);
                alarmsFolder.Add(newAlarm);
            }
        }
    }
}
