#region StandardUsing
using System;
using FTOptix.Core;
using FTOptix.CoreBase;
using FTOptix.HMIProject;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.NetLogic;
using FTOptix.UI;
using FTOptix.OPCUAServer;
#endregion

public class UIFetcher : FTOptix.NetLogic.BaseNetLogic
{
    public override void Start()
    {
        myDelayedTask = new DelayedTask(LoadRemotePanel, 2000, LogicObject);
        myDelayedTask.Start();
    }
    public void LoadRemotePanel() {
        var clientPanelLoader = (PanelLoader)LogicObject.Owner.Get("ClientPanelLoader");
        var remoteMainPanel = Project.Current.Get("UI/RemotePanels/MainPanel");
        if (remoteMainPanel == null) {
            Log.Error("Remote server main panel not found");
            return;
        }
        clientPanelLoader.ChangePanel(remoteMainPanel.NodeId, NodeId.Empty);
    }
    [ExportMethod]
    public void ReloadRemote() {
        Start();
    }
    public override void Stop()
    {
        // Insert code to be executed when the user-defined logic is stopped
        myDelayedTask.Dispose();
    }
    private DelayedTask myDelayedTask;
}
