#region Using directives
using System;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.HMIProject;
using FTOptix.UI;
using FTOptix.Retentivity;
using FTOptix.NativeUI;
using FTOptix.Core;
using FTOptix.CoreBase;
using FTOptix.NetLogic;
#endregion

public class CreateLocalizedLabels : BaseNetLogic
{
    [ExportMethod]
    public void Method1()
    {
        String labelName = "MyLabelName";
        Label myLabel = Owner.Get<Label>(labelName);
        if (myLabel == null ) {
            myLabel = InformationModel.Make<Label>(labelName);
            myLabel.LocalizedText = new LocalizedText(myLabel.NodeId.NamespaceIndex, "myKey1");
            Owner.Add(myLabel);
        } else {
            Log.Warning("Label with name " + labelName + " already exists");
        }
    }
}
