#region Using directives
using System;
using FTOptix.CoreBase;
using FTOptix.HMIProject;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.NetLogic;
using FTOptix.Core;
using FTOptix.UI;
#endregion

public class ChangeUserButtonLogic : BaseNetLogic
{
    [ExportMethod]
    public void PerformChangeUser(string username, string password)
    {
        var usersAlias = LogicObject.GetAlias("Users");
        if (usersAlias == null || usersAlias.NodeId == NodeId.Empty)
        {
            Log.Error("ChangeUserButtonLogic", "Missing Users alias");
            return;
        }

        var user = usersAlias.Get<User>(username);
        if (user == null)
        {
            Log.Error("ChangeUserButtonLogic", "Could not find user " + username);
            return;
        }

        var passwordExpiredDialogType = LogicObject.GetAlias("PasswordExpiredDialogType") as DialogType;
        if (passwordExpiredDialogType == null)
        {
            Log.Error("ChangeUserButtonLogic", "Missing PasswordExpiredDialogType alias");
            return;
        }

        try
        {
            var changeUserResult = Session.ChangeUser(username, password);
            if (changeUserResult.ResultCode == ChangeUserResultCode.PasswordExpired)
            {
                var ownerButton = (Button)Owner;
                ownerButton.OpenDialog(passwordExpiredDialogType, user.NodeId);
                return;
            }

            var outputMessageLabel = Owner.Owner.GetObject("ChangeUserFormOutputMessage");
            var outputMessageLabelResultCode = outputMessageLabel.GetVariable("LoginResultCode");
            outputMessageLabelResultCode.Value = changeUserResult.Success ? 0 : 1;

            string outputMessage = outputMessageLabel.GetVariable("Message").Value;
            var outputMessageLogic = outputMessageLabel.GetObject("ChangeUserFormOutputMessageLogic");
            outputMessageLogic.ExecuteMethod("SetOutputMessage", new object[] { outputMessage });
        }
        catch (Exception e)
        {
            Log.Error("ChangeUserButtonLogic", e.Message);
        }
    }

}
