#region Using directives
using System;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.HMIProject;
using FTOptix.Retentivity;
using FTOptix.NativeUI;
using FTOptix.UI;
using FTOptix.OPCUAClient;
using FTOptix.Core;
using FTOptix.CoreBase;
using FTOptix.NetLogic;
using FTOptix.UI;
#endregion

public class PanelFetcher : BaseNetLogic
{
    PeriodicTask checkConnectionStatus;
    public override void Start()
    {
        checkConnectionStatus = new PeriodicTask(LoadRemotePanel, 500, LogicObject);
        checkConnectionStatus.Start();
    }

    public override void Stop()
    {
        // Insert code to be executed when the user-defined logic is stopped
        checkConnectionStatus?.Dispose();
    }

    private void LoadRemotePanel()
    {
        if (Project.Current.Get<OPCUAClient>("OPC-UA/OPCUAClient1").ConnectionStatus != ConnectionStatus.Connected) {
            return;
        }

        var importedPanel = Project.Current.Get("UI/Panels/Panel1");
        if (importedPanel == null)
        {
            Log.Error("Could not find remote panel");
            return;
        }

        var mainWindowPanelLoader = LogicObject.Owner.Get<FTOptix.UI.PanelLoader>("ClientPanelLoader");
        // Change panel to the imported remote panel.
        mainWindowPanelLoader.ChangePanel(importedPanel.NodeId, NodeId.Empty);

        checkConnectionStatus.Dispose();
    }
}
