using System.Threading;
using UAManagedCore;

public class ProcessVariableSimulatorLogic : FTOptix.NetLogic.BaseNetLogic
{
    public override void Start()
    {
        var owner = (ProcessVariableSimulator)LogicObject.Owner;
        valueVariable = owner.ValueVariable;
        stepVariable = owner.StepVariable;
        messageVariable = owner.MessageVariable;
        isRunningVariable = owner.IsRunningVariable;
        increment = true;

        periodicTask = new PeriodicTask(IncrementDecrementTask, 500, LogicObject);
        periodicTask.Start();

        longRunningTask = new LongRunningTask(MessageTask, LogicObject);
        longRunningTask.Start();
    }

    public override void Stop()
    {
        periodicTask.Dispose();
        periodicTask = null;
        longRunningTask.Dispose();
        longRunningTask = null;
    }

    [FTOptix.NetLogic.ExportMethod]
    public void StartMethod()
    {
        periodicTask.Start();
        isRunningVariable.Value = true;
    }

    [FTOptix.NetLogic.ExportMethod]
    public void StopMethod()
    {
        periodicTask.Cancel();
        isRunningVariable.Value = false;
    }

    public void IncrementDecrementTask()
    {
        int currentValue = valueVariable.Value;
        int step = stepVariable.Value;

        if (increment)
        {
            currentValue += step;
            if (currentValue >= 100)
            {
                currentValue = 100;
                increment = false;
            }
        }
        else
        {
            currentValue -= step;
            if (currentValue <= 0)
            {
                currentValue = 0;
                increment = true;
            }
        }

        valueVariable.Value = currentValue;
    }

    public void MessageTask()
    {
        Thread.Sleep(2000);
        messageVariable.Value = "PHASE 1";

        Thread.Sleep(2000);
        messageVariable.Value = "PHASE 2";

        Thread.Sleep(2000);
        messageVariable.Value = "PHASE 3";

        Thread.Sleep(2000);
        messageVariable.Value = "PHASE 4";
    }

    private IUAVariable valueVariable;
    private IUAVariable stepVariable;
    private IUAVariable messageVariable;
    private IUAVariable isRunningVariable;
    private bool increment;
    private PeriodicTask periodicTask;
    private LongRunningTask longRunningTask;
}
