#region Using directives
using System;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.HMIProject;
using FTOptix.UI;
using FTOptix.NativeUI;
using FTOptix.Core;
using FTOptix.CoreBase;
using FTOptix.NetLogic;
using FTOptix.Retentivity;
using FTOptix.OPCUAServer;
#endregion

public class UserManagementScript : BaseNetLogic
{
    public override void Start()
    {
        // Insert code to be executed when the user-defined logic is started
    }

    public override void Stop()
    {
        // Insert code to be executed when the user-defined logic is stopped
    }

    [ExportMethod]
    public void AddUser(string name, string password, string localeId)
    {
        // Get the current project folder.
        var currentProject = Project.Current;
        var securityFolder = currentProject.GetObject("Security");
        var usersFolder = securityFolder.GetObject("Users");

        // Check the password length.
        if (password.Length < 1)
            return;

        // Creating a new User and set its locale and password.
        var newUser = InformationModel.MakeObject<User>(name);
        Session.ChangePassword(name, password, string.Empty);
        newUser.LocaleId = localeId;

        if (usersFolder == null)
        {
            Log.Error("Add User", "Missing Users folder");
            return;
        }
        usersFolder.Children.Add(newUser.NodeId);
    }
    [ExportMethod]
    public void RemoveUser(string name)
    {
        // Get the current project folder.
        var currentProject = Project.Current;
        var securityFolder = currentProject.GetObject("Security");
        var usersFolder = securityFolder.GetObject("Users");

        if (usersFolder == null)
        {
            Log.Error("Add User", "Missing Users folder");
            return;
        }

        if (usersFolder.Children.Count <= 0)
        {
            Log.Error("Users folder is Empty");
            return;
        }

        // Remove the User by the name.
        usersFolder.Children.Remove(name);
    }
}
