#region Using directives
using System;
using FTOptix.Core;
using UAManagedCore;
using OpcUa = UAManagedCore.OpcUa;
using FTOptix.HMIProject;
using FTOptix.OPCUAServer;
using FTOptix.UI;
using FTOptix.NativeUI;
using FTOptix.CoreBase;
using FTOptix.NetLogic;
using System.Collections.Generic;
using System.Text;
using FTOptix.Alarm;
using FTOptix.EventLogger;
using FTOptix.Store;
using FTOptix.SQLiteStore;
using FTOptix.CommunicationDriver;
using FTOptix.Modbus;
using FTOptix.Recipe;
#endregion

public class AudiEventLogger : BaseNetLogic, IUAEventObserver
{
    public override void Start()
    {
        var serverObject = LogicObject.Context.GetObject(OpcUa.Objects.Server);
        //eventRegistration = serverObject.RegisterUAEventObserver(this, UAManagedCore.OpcUa.ObjectTypes.AuditNodeManagementEventType);
    }

    public override void Stop()
    {
        // Insert code to be executed when the user-defined logic is stopped
    }

    public void OnEvent(IUAObject eventNotifier, IUAObjectType eventType, IReadOnlyList<object> eventData, ulong senderId)
    {
        StringBuilder builder = new StringBuilder();
        builder.Append($"Event of type {eventType.BrowseName} triggered");

        var eventArguments = eventType.EventArguments;
        foreach (var eventField in eventArguments.GetFields())
        {
            var fieldValue = eventArguments.GetFieldValue(eventData, eventField);
            if (eventField == "NodesToAdd")
            {
                var nodesToAdd = (Struct[])fieldValue;
                var childNode = nodesToAdd[0].Get(2);
                var node = LogicObject.Context.GetNode((NodeId)childNode);
                builder.Append($"\t{eventField} = {node?.BrowseName ?? "null"}");
            }
            else
            {
                builder.Append($"\t{eventField} = {fieldValue?.ToString() ?? "null"}");
            }
        }

        builder.Append("\n");
        Log.Info(builder.ToString());
    }

   // private IEventRegistration eventRegistration;
}
